Include([[Data/levels/include/level_utils.lua]])

Level =
{
	MapSkinFilename = [[caves.lua]],
	MapGenScript = LevelUtils.MapGenFromSVG([[tutorial_combat.svg]]),
	Parameters =
	{
		MarineCount 		= 5,
		StartBPMultiplier 	= 1.0,
		BPGainMultiplier 	= 1.0,
		MaxHiveLevel 		= 3,
		MaxSpawnRate 		= 4.0,
	},
	Mutations =
	{
		CapturesPerMutation = 1,
		MaxMutations = 0,
		Default = [[disabled]],
		Active =
		{
		},
		Queue =
		{
		},
		Disabled =
		{
		},
	},
	MarineUpgrades = 
	{
		--Default = [[locked]],
		Active =
		{
			[[MU_GRENADES]],
		},
		Inactive =
		{
		},	
		Locked =
		{
		},			
	}
}

------------------------------------------------------------------------------- Level Init
LevelInit = LevelUtils.MakeGoal(
	nil,
	
	{[[NT_BEGIN_GAME]]},
	function (self, p_type, p_entId, p_pos, p_other)
		self:Disable()
	
		GameWorld:SetUIVisibility("ResourceGroup", false)
		GameWorld:SetUIVisibility("commandMenu", false)
		GameWorld:SetUIVisibility("constructionMenu", false)
		GameWorld:SetUIVisibility("MutationList", false)
		GameWorld:SetUIVisibility("Objectives", false)
		GameWorld:SetUIVisibility("researchMenu", false)
		GameWorld:SetUIVisibility("trainingMenu", false)
		GameWorld:SetUIVisibility("armouryMenu", false)
		GameWorld:SetUIVisibility("MarineTabGroup", false)
		GameWorld:SetUIVisibility("MarineSpawnGroup", false)
				
		MarineBoxSelectGoal:Enable()
	end)
LevelInit:Enable()
	
------------------------------------------------------------------------------- Select A Marine
MarineBoxSelectGoal = LevelUtils.MakeGoal(
	function (self)
		GameWorld:CreateTrainingArrow("startPoint")
		GameWorld:ShowText("Here's the deal folks.  We need to roll through this patch of grubs to get to our target.\n\nCan't have this mess at our backs.  Take the team and capture this entire sector.", "Sarge")
	end,
	
	{[[NT_ENTITY_BOX_SELECTION]]},
	function (self, p_type, p_entId, p_pos, p_other)
		self:Disable()
		
		--GameWorld:ShowText("Capture the nearest point")
		GameWorld:CreateTrainingArrow("firstpoint")
	end,
	
	function (self)
		GameWorld:RemoveTrainingArrow("startPoint")
		GameWorld:SetUIVisibility("MarineTabGroup", true)
	end)

------------------------------------------------------------------------------- Capture the first point (short-circuit)
CaptureOneGoal = LevelUtils.MakeGoal(
	nil,
	
	{[[NT_POINT_CAPTURED]]},
	function (self, p_type, p_entId, p_pos, p_other)
		self:Disable()
		MarineBoxSelectGoal:Disable()	
		
		--
		
		GameWorld:SetUIVisibility("commandMenu", true)
		SpawnMarinesGoal:Enable()
        CaptureTwoGoal:Enable()

	end,
	
	function (self)
		GameWorld:RemoveTrainingArrow("firstpoint")
	end)
	
CaptureOneGoal:Enable()

------------------------------------------------------------------------------- Spawn more marines
SpawnMarinesGoal = LevelUtils.MakeGoal(
	function (self)
		GameWorld:SetUIVisibility("MarineSpawnGroup", true)
		GameWorld:SetUIVisibility("ResourceGroup", true)
		
		self.text_hdl = GameWorld:ShowText("Hey, you look a bit lonely out here\n\nLet's get us some backup, eh?", "Sarge")

		GameWorld:SetUIHighlightArrow("MarineSpawnGroup", "MarineSpawnButton", true)
		
		self.backup_count = 0
	end,
	
	{[[NT_MARINE_SPAWNED]]},
	function (self, p_type, p_entId, p_pos, p_other)
		self.backup_count = self.backup_count + 1
        
        if self.backup_count < 3 then
            return
        end

        self:Disable()
				
		CaptureTwoGoal:Enable()
		GameWorld:ShowText("Bet the general is sending the Devils into the sticks to get us out of the way.\n\nWell, s'long as he keeps payin, I don't mind.", "Sarge")
		GameWorld:CreateTrainingArrow("secondpoint")
	end,
	
	function (self)
		self.text_hdl:ClearText()
		
		GameWorld:SetUIHighlightArrow("MarineSpawnGroup", "MarineSpawnButton", false)
	end)

------------------------------------------------------------------------------- Capture the second point (short-circuit)
CaptureTwoGoal = LevelUtils.MakeGoal(

	function (self)
	end,
	
	{[[NT_POINT_CAPTURED]]},
	function (self, p_type, p_entId, p_pos, p_other)
		self:Disable()

		GameWorld:ShowText("You know what?  We need bigger guns.\n\nLet me hop on the phone real quick and order takeout.", "Sarge")
		GameWorld:SetUIVisibility("Objectives", true)		
		
		CaptureThreeGoal:Enable()
		CaptureFourGoal:Enable()		
		CrateDrop:Enable()
		DeadTrigger:Enable()
		SpawnMarinesGoal:Disable()
	end,
	
	function (self)
		GameWorld:RemoveTrainingArrow("secondpoint")
	end)

------------------------------------------------------------------------------- Chopper Delivery
CrateDrop = LevelUtils.MakeGoal(
	function (self)	
		local crateArea = GameWorld:GetEntityById("infoMarkerCrates");
		if crateArea then
			local chopper = GameWorld:SpawnChopper(vect2f(-0.3, 1.0), crateArea:GetPos())
			chopper:SetMission(ChopperOrder.CO_DELIVERY, crateArea:GetPos(), "Crates")
		end
	end,
	
	{[[NT_CHOPPER_DELIVERY]]},
	function (self, p_type, p_entId, p_pos, p_other)
		
		if p_other ~= "Crates" then
			return
		end
		
		GameWorld:CreateEntity("WeaponCrate:WT_FUSIONRIFLE", "", p_pos + vect2f(3.5,0))
		GameWorld:CreateEntity("WeaponCrate:WT_FUSIONRIFLE", "", p_pos + vect2f(-3.5,3.5))
		GameWorld:CreateEntity("WeaponCrate:WT_FUSIONRIFLE", "", p_pos + vect2f(-3.5,-3.5))
		
		GameWorld:ShowText("I love my shotguns - babies kick like a mule though.\n\nLet's grab a couple from those crates down there.", "Sarge")
	
		WeaponCrateGoal:Enable()
	
		self:Disable()
	end)

	
------------------------------------------------------------------------------- Capture the third point
CaptureThreeGoal = LevelUtils.MakeGoal(
	function (self)
		GameWorld:CreateTrainingArrow("thirdpoint")
	end,
	
	{[[NT_POINT_CAPTURED]]},
	function (self, p_type, p_entId, p_pos, p_other)
		if p_entId ~= "thirdpoint" then
			return
		end
		
		self:Disable()
	end,
	
	function (self)
		GameWorld:RemoveTrainingArrow("thirdpoint")
	end)

------------------------------------------------------------------------------- Capture the fourth point
CaptureFourGoal = LevelUtils.MakeGoal(
	function (self)
		GameWorld:CreateTrainingArrow("fourthpoint")
	end,
	
	{[[NT_POINT_CAPTURED]]},
	function (self, p_type, p_entId, p_pos, p_other)
		if p_entId ~= "fourthpoint" then
			return
		end
		
		self:Disable()
	end,
	
	function (self)
		GameWorld:RemoveTrainingArrow("fourthpoint")
	end)

------------------------------------------------------------------------------- Pick up weapon crates
WeaponCrateGoal = LevelUtils.MakeGoal(
	function (self)
		GameWorld:CreateTrainingArrow("infoMarkerCrates", [[PNT_ATTENTION]])
		
		GameWorld:AddObjective("crateObj", "Pick up shotgun crates")
		
		crateArea = GameWorld:GetEntityById("infoMarkerCrates")
		self.event_pos = crateArea:GetPos()
		self.event_radius = crateArea:GetRadius()
	end,
	
	{[[NT_POWERUP_CAPTURED]]},
	function (self, p_type, p_entId, p_pos, p_other)
		if not vect2f.IsDistLess(p_pos, self.event_pos, self.event_radius) then
			return
		end

		--GameWorld:MakeAnnouncement("Objective\nComplete")
		GameWorld:ChangeObjectiveStatus("crateObj", [[complete]])
		GameWorld:ChangeStat("ST_OBJECTIVE_REWARD_COUNT", 1)
		
		GameWorld:ClearText()
		
		self:Disable()
	end,
	
	function (self)
		GameWorld:RemoveTrainingArrow("infoMarkerCrates", [[PNT_ATTENTION]])
	end)

------------------------------------------------------------------------------- Happens when a marine dies
DeadTrigger = LevelUtils.MakeGoal(
	nil,
	
	{[[NT_ENTITY_DESTROYED]]},
	function (self, p_type, p_entId, p_pos, p_other)
		local deadEnt = GameWorld:GetEntityById(p_entId)
		if deadEnt and deadEnt:ToCHuman() then
		
            self:Disable()
            BackFromTheDeadTrigger:Enable()
            
        end
	end)

------------------------------------------------------------------------------- Happens when a marine dies and respawns
BackFromTheDeadTrigger = LevelUtils.MakeGoal(
	nil,
	
	{[[NT_MARINE_RESPAWNED]]},
	function (self, p_type, p_entId, p_pos, p_other)
		self:Disable()
		
		BackFromTheDeadSelectGoal.targetEntId = p_entId
		BackFromTheDeadSelectGoal:Enable()
	end)

------------------------------------------------------------------------------- Select the marine who respawns
BackFromTheDeadSelectGoal = LevelUtils.MakeGoal(
	function (self)
		GameWorld:ShowText("One of yer men's back in action lieutenant.\n\nI've marked him on the HUD so that you can find him real quick.", "Sarge")
		GameWorld:CreateTrainingArrow(self.targetEntId)
		GameWorld:AddObjective("respawnObj", "Select the respawned marine")
	end,
	
	{[[NT_ENTITY_SELECTION]]},
	function (self, p_type, p_entId, p_pos, p_other)
		if p_entId ~= self.targetEntId then
			return
		end
	
		self:Disable()
		
		--GameWorld:MakeAnnouncement("Objective\nComplete")
		GameWorld:ChangeObjectiveStatus("respawnObj", [[complete]])
		GameWorld:ChangeStat("ST_OBJECTIVE_REWARD_COUNT", 1)
	end,
	
	function (self)
		GameWorld:ClearText()
		GameWorld:RemoveTrainingArrow(self.targetEntId)
	end)
	
------------------------------------------------------------------------------- Capture All Points (short-circuit)
CaptureAllGoal = LevelUtils.MakeGoal(
	nil,
	
	{[[NT_ALL_POINTS_CAPTURED]]},
	function (self, p_type, p_entId, p_pos, p_other)
		GameWorld:ClearText()
		GameWorld:GameOver(true)
		
		self:Disable()
	end) 
	
CaptureAllGoal:Enable()